import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
public class Target 
{
	private BufferedImage img;
	private int x,y,w,h, deltaX;
	public Target(BufferedImage img){
		this.img=img;
		x=400;
		y=25;
		w=75;
		h=70;
		deltaX=randomInt(3,8);
	}
	public boolean touches(Rectangle2D object){
		if(deltaX>0)
			return object.intersects(x-w, y, w, h);
		return object.intersects(x, y, w, h);
	}
	public int randomInt(int min, int max){
		return min+(int)(max*Math.random());
	}
	public void move(){
		x+=deltaX;
		if (x+w>800){
			deltaX=-1*randomInt(3,8);
			x=800-w;
		}
		if (x<0){
			deltaX=randomInt(3,8);
			x=w;
		}
	}
	public void draw(Graphics g){
		int rightSide=x-w;
		if (deltaX<0)
			rightSide=x+w;		
		g.drawImage(img, x, y, rightSide, y+h, 0, 0, img.getWidth(), img.getHeight(), null);
	}
	public int getSpeed(){
		return Math.abs(deltaX);
	}
}